<?php
/**
 * Database Configuration
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

// Prevent direct access
if (!defined('HRM_ACCESS')) {
    die('Direct access not permitted');
}

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'rjkkymxqay_hrm');
define('DB_USER', 'rjkkymxqay_hrmu');        // Replace with your database username
define('DB_PASS', '0715719676Bcg');        // Replace with your database password
define('DB_CHARSET', 'utf8mb4');

// Database Connection Class
class Database {
    private static $instance = null;
    private $connection;
    
    private function __construct() {
        try {
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES " . DB_CHARSET
            ];
            
            $this->connection = new PDO($dsn, DB_USER, DB_PASS, $options);
            
        } catch (PDOException $e) {
            error_log("Database Connection Error: " . $e->getMessage());
            die("Database connection failed. Please try again later.");
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->connection;
    }
    
    // Prevent cloning
    private function __clone() {}
    
    // Prevent unserialization
    public function __wakeup() {}
}

// Global database connection function
function getDB() {
    return Database::getInstance()->getConnection();
}

// Database helper functions
function executeQuery($sql, $params = []) {
    try {
        $db = getDB();
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
        return $stmt;
    } catch (PDOException $e) {
        error_log("Query Error: " . $e->getMessage() . " | SQL: " . $sql);
        throw new Exception("Database query failed");
    }
}

function fetchOne($sql, $params = []) {
    $stmt = executeQuery($sql, $params);
    return $stmt->fetch();
}

function fetchAll($sql, $params = []) {
    $stmt = executeQuery($sql, $params);
    return $stmt->fetchAll();
}

function insertRecord($table, $data) {
    $fields = array_keys($data);
    $placeholders = ':' . implode(', :', $fields);
    $fieldList = implode(', ', $fields);
    
    $sql = "INSERT INTO {$table} ({$fieldList}) VALUES ({$placeholders})";
    
    try {
        $stmt = executeQuery($sql, $data);
        return getDB()->lastInsertId();
    } catch (Exception $e) {
        error_log("Insert Error: " . $e->getMessage());
        throw new Exception("Failed to insert record");
    }
}


// Fixed updateRecord function - replace the existing one in database.php

function updateRecord($table, $data, $where, $whereParams = []) {
    $setParts = [];
    $params = [];
    
    // Build SET clause with positional parameters
    foreach ($data as $field => $value) {
        $setParts[] = "{$field} = ?";
        $params[] = $value;
    }
    $setClause = implode(', ', $setParts);
    
    // Add WHERE parameters
    $params = array_merge($params, $whereParams);
    
    $sql = "UPDATE {$table} SET {$setClause} WHERE {$where}";
    
    try {
        $stmt = executeQuery($sql, $params);
        return $stmt->rowCount();
    } catch (Exception $e) {
        error_log("Update Error: " . $e->getMessage());
        throw new Exception("Failed to update record");
    }
}

function deleteRecord($table, $where, $params = []) {
    $sql = "DELETE FROM {$table} WHERE {$where}";
    
    try {
        $stmt = executeQuery($sql, $params);
        return $stmt->rowCount();
    } catch (Exception $e) {
        error_log("Delete Error: " . $e->getMessage());
        throw new Exception("Failed to delete record");
    }
}

// Transaction helpers
function beginTransaction() {
    return getDB()->beginTransaction();
}

function commit() {
    return getDB()->commit();
}

function rollback() {
    return getDB()->rollBack();
}

// Test database connection
function testConnection() {
    try {
        $db = getDB();
        $stmt = $db->query("SELECT 1");
        return true;
    } catch (Exception $e) {
        return false;
    }
}

// Sanitize input for database
function sanitizeInput($input) {
    if (is_array($input)) {
        return array_map('sanitizeInput', $input);
    }
    
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

// Generate unique reference numbers
function generateRequestNumber() {
    $year = date('Y');
    $sql = "SELECT COUNT(*) as count FROM employee_requests WHERE YEAR(created_at) = ?";
    $result = fetchOne($sql, [$year]);
    $count = $result['count'] + 1;
    return sprintf("REQ-%s-%03d", $year, $count);
}

function generateApplicationNumber() {
    $year = date('Y');
    $sql = "SELECT COUNT(*) as count FROM job_applications WHERE YEAR(submitted_at) = ?";
    $result = fetchOne($sql, [$year]);
    $count = $result['count'] + 1;
    return sprintf("APP-%s-%03d", $year, $count);
}

// Log system activities
function logActivity($userId, $action, $tableName, $recordId, $oldValues = null, $newValues = null) {
    $data = [
        'user_id' => $userId,
        'action' => $action,
        'table_name' => $tableName,
        'record_id' => $recordId,
        'old_values' => $oldValues ? json_encode($oldValues) : null,
        'new_values' => $newValues ? json_encode($newValues) : null,
        'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1',
        'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
    ];
    
    try {
        insertRecord('system_logs', $data);
    } catch (Exception $e) {
        error_log("Failed to log activity: " . $e->getMessage());
    }
}

// Database maintenance functions
function optimizeTables() {
    $tables = [
        'users', 'sites_projects', 'employee_requests', 'employee_categories',
        'approval_logs', 'job_applications', 'employee_documents',
        'application_approval_logs', 'system_logs'
    ];
    
    try {
        $db = getDB();
        foreach ($tables as $table) {
            $db->exec("OPTIMIZE TABLE {$table}");
        }
        return true;
    } catch (Exception $e) {
        error_log("Table optimization error: " . $e->getMessage());
        return false;
    }
}

function cleanupOldLogs($days = 365) {
    try {
        $sql = "DELETE FROM system_logs WHERE created_at < DATE_SUB(NOW(), INTERVAL ? DAY)";
        $stmt = executeQuery($sql, [$days]);
        return $stmt->rowCount();
    } catch (Exception $e) {
        error_log("Log cleanup error: " . $e->getMessage());
        return false;
    }
}

?>