<?php
/**
 * Accountant Dashboard
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

$page_title = 'Accountant Dashboard';
$active_menu = 'dashboard';

// Check permission
require_once '../includes/header.php';
requirePermission(ROLE_ACCOUNTANT);

// Get dashboard statistics
$stats = getDashboardStats($_SESSION['user_id'], $_SESSION['role']);
?>

<div class="row mb-4">
    <div class="col-12">
        <h4 class="mb-0">Accountant Dashboard</h4>
        <small class="text-muted">Financial approval and cost management</small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-danger"><?php echo $stats['pending_approvals'] ?? 0; ?></h3>
                <small>Pending Approvals</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-success"><?php echo $stats['hired_employees'] ?? 0; ?></h3>
                <small>Hired Employees</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-warning"><?php echo formatCurrencyAmount($stats['total_salary_cost'] ?? 0); ?></h3>
                <small>Salary Cost</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-info"><?php echo $stats['total_applications'] ?? 0; ?></h3>
                <small>Applications</small>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Quick Actions</div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="../employees/approve_application.php" class="btn btn-danger btn-sm">
                        <i class="fas fa-dollar-sign me-2"></i>Financial Approvals
                    </a>
                    <a href="../employees/view_applications.php" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-list me-2"></i>All Applications
                    </a>
                    <a href="../reports/hiring_report.php" class="btn btn-outline-success btn-sm">
                        <i class="fas fa-chart-pie me-2"></i>Cost Reports
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Pending Financial Approvals</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT ja.application_number, ja.full_name_english, ja.position_applied, ja.expected_salary
                            FROM job_applications ja
                            WHERE ja.status = 'approved_by_hr'
                            ORDER BY ja.expected_salary DESC
                            LIMIT 5";
                    $pending = fetchAll($sql);
                    
                    if ($pending):
                        foreach ($pending as $item):
                ?>
                <div class="d-flex justify-content-between border-bottom py-2">
                    <div>
                        <small><strong><?php echo htmlspecialchars($item['full_name_english']); ?></strong></small><br>
                        <small class="text-muted"><?php echo htmlspecialchars($item['position_applied']); ?></small>
                    </div>
                    <small class="text-muted"><?php echo formatCurrencyAmount($item['expected_salary']); ?></small>
                </div>
                <?php 
                        endforeach;
                    else:
                ?>
                <small class="text-muted">No pending approvals</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load approvals</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- Salary Summary -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">Salary Summary by Position</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT ja.position_applied, 
                                COUNT(*) as count,
                                AVG(ja.expected_salary) as avg_salary,
                                SUM(ja.expected_salary) as total_salary
                            FROM job_applications ja
                            WHERE ja.status = 'hired' AND ja.expected_salary > 0
                            GROUP BY ja.position_applied
                            ORDER BY total_salary DESC
                            LIMIT 8";
                    $salaries = fetchAll($sql);
                    
                    if ($salaries):
                ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Position</th>
                                <th>Count</th>
                                <th>Avg Salary</th>
                                <th>Total Cost</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($salaries as $salary): ?>
                            <tr>
                                <td><small><?php echo htmlspecialchars($salary['position_applied']); ?></small></td>
                                <td><small><?php echo $salary['count']; ?></small></td>
                                <td><small><?php echo formatCurrencyAmount($salary['avg_salary']); ?></small></td>
                                <td><small><?php echo formatCurrencyAmount($salary['total_salary']); ?></small></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <small class="text-muted">No salary data available</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load salary data</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>