<?php
/**
 * General Manager Dashboard
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

$page_title = 'General Manager Dashboard';
$active_menu = 'dashboard';

// Check permission
require_once '../includes/header.php';
requirePermission(ROLE_GENERAL_MANAGER);

// Get dashboard statistics
$stats = getDashboardStats($_SESSION['user_id'], $_SESSION['role']);
?>

<div class="row mb-4">
    <div class="col-12">
        <h4 class="mb-0">General Manager Dashboard</h4>
        <small class="text-muted">Company-wide recruitment overview</small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-danger"><?php echo $stats['pending_requests'] ?? 0; ?></h3>
                <small>Pending Approvals</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-info"><?php echo $stats['total_requests'] ?? 0; ?></h3>
                <small>Total Requests</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-warning"><?php echo $stats['total_applications'] ?? 0; ?></h3>
                <small>Applications</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-success"><?php echo $stats['hired_employees'] ?? 0; ?></h3>
                <small>Hired Employees</small>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Quick Actions</div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="../requests/approve_request.php" class="btn btn-danger btn-sm">
                        <i class="fas fa-check-circle me-2"></i>Approve Requests
                    </a>
                    <a href="../requests/view_requests.php" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-list me-2"></i>All Requests
                    </a>
                    <a href="../reports/request_summary.php" class="btn btn-outline-success btn-sm">
                        <i class="fas fa-chart-bar me-2"></i>Request Reports
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Requests Awaiting Approval</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT er.request_number, er.site_project, er.created_at, u.full_name
                            FROM employee_requests er
                            JOIN users u ON er.requested_by = u.id
                            WHERE er.status = 'approved_by_pm'
                            ORDER BY er.created_at ASC
                            LIMIT 5";
                    $pending = fetchAll($sql);
                    
                    if ($pending):
                        foreach ($pending as $item):
                ?>
                <div class="d-flex justify-content-between border-bottom py-2">
                    <div>
                        <small><strong><?php echo htmlspecialchars($item['request_number']); ?></strong></small><br>
                        <small class="text-muted"><?php echo htmlspecialchars($item['site_project']); ?></small>
                    </div>
                    <small class="text-muted"><?php echo getRelativeTime($item['created_at']); ?></small>
                </div>
                <?php 
                        endforeach;
                    else:
                ?>
                <small class="text-muted">No pending approvals</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load pending items</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- Project Overview -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">Projects Overview</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT sp.name, sp.code, 
                                COUNT(er.id) as request_count,
                                COUNT(CASE WHEN ja.status = 'hired' THEN 1 END) as hired_count
                            FROM sites_projects sp
                            LEFT JOIN employee_requests er ON sp.name = er.site_project
                            LEFT JOIN job_applications ja ON er.id = ja.request_id
                            WHERE sp.status = 'active'
                            GROUP BY sp.id
                            ORDER BY request_count DESC
                            LIMIT 5";
                    $projects = fetchAll($sql);
                    
                    if ($projects):
                ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Project</th>
                                <th>Code</th>
                                <th>Requests</th>
                                <th>Hired</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($projects as $project): ?>
                            <tr>
                                <td><small><?php echo htmlspecialchars($project['name']); ?></small></td>
                                <td><small><?php echo htmlspecialchars($project['code']); ?></small></td>
                                <td><small><?php echo $project['request_count']; ?></small></td>
                                <td><small><?php echo $project['hired_count']; ?></small></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <small class="text-muted">No project data available</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load project data</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>