<?php
/**
 * HR Manager Dashboard
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

$page_title = 'HR Manager Dashboard';
$active_menu = 'dashboard';

// Check permission
require_once '../includes/header.php';
requirePermission(ROLE_HR_MANAGER);

// Get dashboard statistics
$stats = getDashboardStats($_SESSION['user_id'], $_SESSION['role']);
?>

<div class="row mb-4">
    <div class="col-12">
        <h4 class="mb-0">HR Manager Dashboard</h4>
        <small class="text-muted">Human resources and recruitment management</small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-danger"><?php echo $stats['pending_request_approvals'] ?? 0; ?></h3>
                <small>Request Approvals</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-warning"><?php echo $stats['pending_application_approvals'] ?? 0; ?></h3>
                <small>Application Approvals</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-success"><?php echo $stats['hired_employees'] ?? 0; ?></h3>
                <small>Hired Employees</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-info"><?php echo $stats['total_applications'] ?? 0; ?></h3>
                <small>Total Applications</small>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="../requests/approve_request.php" class="btn btn-danger btn-sm">
                        <i class="fas fa-clipboard-check me-2"></i>Approve Requests
                    </a>
                    <a href="../employees/approve_application.php" class="btn btn-warning btn-sm">
                        <i class="fas fa-user-check me-2"></i>Review Applications
                    </a>
                    <a href="../employees/view_applications.php" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-users me-2"></i>All Applications
                    </a>
                    <a href="../reports/hiring_report.php" class="btn btn-outline-success btn-sm">
                        <i class="fas fa-chart-line me-2"></i>Hiring Reports
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Applications Pending Review</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT ja.application_number, ja.full_name_english, ja.position_applied, ja.submitted_at
                            FROM job_applications ja
                            WHERE ja.status = 'approved_by_pm'
                            ORDER BY ja.submitted_at ASC
                            LIMIT 5";
                    $pending = fetchAll($sql);
                    
                    if ($pending):
                        foreach ($pending as $item):
                ?>
                <div class="d-flex justify-content-between border-bottom py-2">
                    <div>
                        <small><strong><?php echo htmlspecialchars($item['full_name_english']); ?></strong></small><br>
                        <small class="text-muted"><?php echo htmlspecialchars($item['position_applied']); ?></small>
                    </div>
                    <small class="text-muted"><?php echo getRelativeTime($item['submitted_at']); ?></small>
                </div>
                <?php 
                        endforeach;
                    else:
                ?>
                <small class="text-muted">No pending applications</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load applications</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- Recent Hires -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">Recent Hires</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT ja.full_name_english, ja.position_applied, er.site_project, ja.updated_at
                            FROM job_applications ja
                            JOIN employee_requests er ON ja.request_id = er.id
                            WHERE ja.status = 'hired'
                            ORDER BY ja.updated_at DESC
                            LIMIT 8";
                    $hires = fetchAll($sql);
                    
                    if ($hires):
                ?>
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Position</th>
                                <th>Project</th>
                                <th>Hired Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($hires as $hire): ?>
                            <tr>
                                <td><small><?php echo htmlspecialchars($hire['full_name_english']); ?></small></td>
                                <td><small><?php echo htmlspecialchars($hire['position_applied']); ?></small></td>
                                <td><small><?php echo htmlspecialchars($hire['site_project']); ?></small></td>
                                <td><small><?php echo formatDisplayDate($hire['updated_at']); ?></small></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                <small class="text-muted">No recent hires</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load hiring data</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>
            