<?php
/**
 * Project Manager Dashboard
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

$page_title = 'Project Manager Dashboard';
$active_menu = 'dashboard';

// Check permission
require_once '../includes/header.php';
requirePermission(ROLE_PROJECT_MANAGER);

// Get dashboard statistics
$stats = getDashboardStats($_SESSION['user_id'], $_SESSION['role']);
$currentUser = getCurrentUser();
?>

<div class="row mb-4">
    <div class="col-12">
        <h4 class="mb-0">Project Manager Dashboard</h4>
        <small class="text-muted"><?php echo htmlspecialchars($currentUser['site_project']); ?></small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-danger"><?php echo $stats['pending_requests'] ?? 0; ?></h3>
                <small>Pending Requests</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-warning"><?php echo $stats['pending_applications'] ?? 0; ?></h3>
                <small>Pending Applications</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-info"><?php echo $stats['total_requests'] ?? 0; ?></h3>
                <small>Total Requests</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-success"><?php echo $stats['total_applications'] ?? 0; ?></h3>
                <small>Applications</small>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Quick Actions</div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="../requests/approve_request.php" class="btn btn-danger btn-sm">
                        <i class="fas fa-clock me-2"></i>Pending Request Approvals
                    </a>
                    <a href="../employees/approve_application.php" class="btn btn-warning btn-sm">
                        <i class="fas fa-user-check me-2"></i>Pending Application Approvals
                    </a>
                    <a href="../requests/view_requests.php" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-list me-2"></i>All Project Requests
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Pending Approvals</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT er.request_number, er.status, er.created_at, u.full_name
                            FROM employee_requests er
                            JOIN users u ON er.requested_by = u.id
                            WHERE er.site_project = ? AND er.status = 'pending'
                            ORDER BY er.created_at ASC
                            LIMIT 5";
                    $pending = fetchAll($sql, [$currentUser['site_project']]);
                    
                    if ($pending):
                        foreach ($pending as $item):
                ?>
                <div class="d-flex justify-content-between border-bottom py-2">
                    <div>
                        <small><strong><?php echo htmlspecialchars($item['request_number']); ?></strong></small><br>
                        <small class="text-muted"><?php echo htmlspecialchars($item['full_name']); ?></small>
                    </div>
                    <small class="text-muted"><?php echo getRelativeTime($item['created_at']); ?></small>
                </div>
                <?php 
                        endforeach;
                    else:
                ?>
                <small class="text-muted">No pending approvals</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load pending items</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- Project Summary -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">Project Summary</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT 
                                COUNT(CASE WHEN er.status != 'rejected' THEN 1 END) as active_requests,
                                COUNT(CASE WHEN ja.status = 'hired' THEN 1 END) as hired_count,
                                COUNT(DISTINCT u.id) as site_admins
                            FROM employee_requests er
                            LEFT JOIN job_applications ja ON er.id = ja.request_id
                            LEFT JOIN users u ON er.requested_by = u.id
                            WHERE er.site_project = ?";
                    $summary = fetchOne($sql, [$currentUser['site_project']]);
                    
                    if ($summary):
                ?>
                <div class="row">
                    <div class="col-md-4">
                        <small><strong>Active Requests:</strong> <?php echo $summary['active_requests']; ?></small>
                    </div>
                    <div class="col-md-4">
                        <small><strong>Hired Employees:</strong> <?php echo $summary['hired_count']; ?></small>
                    </div>
                    <div class="col-md-4">
                        <small><strong>Site Admins:</strong> <?php echo $summary['site_admins']; ?></small>
                    </div>
                </div>
                <?php else: ?>
                <small class="text-muted">No project data available</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load project summary</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>