<?php
/**
 * Site Admin Dashboard
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

$page_title = 'Site Admin Dashboard';
$active_menu = 'dashboard';

// Check permission
require_once '../includes/header.php';
requirePermission(ROLE_SITE_ADMIN);

// Get dashboard statistics
$stats = getDashboardStats($_SESSION['user_id'], $_SESSION['role']);
$currentUser = getCurrentUser();
?>

<div class="row mb-4">
    <div class="col-12">
        <h4 class="mb-0">Site Admin Dashboard</h4>
        <small class="text-muted"><?php echo htmlspecialchars($currentUser['site_project']); ?></small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-warning"><?php echo $stats['pending_requests'] ?? 0; ?></h3>
                <small>Pending Requests</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-success"><?php echo $stats['approved_requests'] ?? 0; ?></h3>
                <small>Approved Requests</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-info"><?php echo $stats['total_applications'] ?? 0; ?></h3>
                <small>Applications</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-primary"><?php echo $stats['total_requests'] ?? 0; ?></h3>
                <small>Total Requests</small>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Quick Actions</div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="../requests/create_request.php" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus me-2"></i>New Employee Request
                    </a>
                    <a href="../employees/application_form.php" class="btn btn-success btn-sm">
                        <i class="fas fa-user-plus me-2"></i>New Application
                    </a>
                    <a href="../requests/view_requests.php" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-list me-2"></i>View My Requests
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">My Recent Requests</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT request_number, status, created_at 
                            FROM employee_requests 
                            WHERE requested_by = ? 
                            ORDER BY created_at DESC 
                            LIMIT 5";
                    $requests = fetchAll($sql, [$_SESSION['user_id']]);
                    
                    if ($requests):
                        foreach ($requests as $request):
                ?>
                <div class="d-flex justify-content-between border-bottom py-2">
                    <div>
                        <small><strong><?php echo htmlspecialchars($request['request_number']); ?></strong></small><br>
                        <small class="text-muted"><?php echo getStatusName($request['status']); ?></small>
                    </div>
                    <small class="text-muted"><?php echo formatDisplayDate($request['created_at']); ?></small>
                </div>
                <?php 
                        endforeach;
                    else:
                ?>
                <small class="text-muted">No requests yet</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load requests</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- Project Info -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">Project Information</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT * FROM sites_projects WHERE name = ?";
                    $project = fetchOne($sql, [$currentUser['site_project']]);
                    
                    if ($project):
                ?>
                <div class="row">
                    <div class="col-md-6">
                        <small><strong>Project:</strong> <?php echo htmlspecialchars($project['name']); ?></small><br>
                        <small><strong>Code:</strong> <?php echo htmlspecialchars($project['code']); ?></small><br>
                        <small><strong>Location:</strong> <?php echo htmlspecialchars($project['location']); ?></small>
                    </div>
                    <div class="col-md-6">
                        <small><strong>Status:</strong> <span class="text-success"><?php echo ucfirst($project['status']); ?></span></small><br>
                        <small><strong>Start Date:</strong> <?php echo formatDisplayDate($project['start_date']); ?></small><br>
                        <small><strong>Expected End:</strong> <?php echo formatDisplayDate($project['expected_end_date']); ?></small>
                    </div>
                </div>
                <?php else: ?>
                <small class="text-muted">Project information not available</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load project information</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>