<?php
/**
 * Super Admin Dashboard
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

$page_title = 'Super Admin Dashboard';
$active_menu = 'dashboard';

// Check permission
require_once '../includes/header.php';
requirePermission(ROLE_SUPER_ADMIN);

// Get dashboard statistics
$stats = getDashboardStats($_SESSION['user_id'], $_SESSION['role']);
?>

<div class="row mb-4">
    <div class="col-12">
        <h4 class="mb-0">Super Admin Dashboard</h4>
        <small class="text-muted">System overview and administration</small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-primary"><?php echo $stats['active_users'] ?? 0; ?></h3>
                <small>Active Users</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-info"><?php echo $stats['active_requests'] ?? 0; ?></h3>
                <small>Active Requests</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-success"><?php echo $stats['total_applications'] ?? 0; ?></h3>
                <small>Total Applications</small>
            </div>
        </div>
    </div>
    <div class="col-md-3 col-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h3 class="text-warning"><?php echo $stats['active_projects'] ?? 0; ?></h3>
                <small>Active Projects</small>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Quick Actions</div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="../admin/users.php" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-users me-2"></i>Manage Users
                    </a>
                    <a href="../admin/projects.php" class="btn btn-outline-info btn-sm">
                        <i class="fas fa-project-diagram me-2"></i>Manage Projects
                    </a>
                    <a href="../admin/system_logs.php" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-history me-2"></i>System Logs
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">Recent Activity</div>
            <div class="card-body">
                <?php
                try {
                    $sql = "SELECT sl.action, u.full_name, sl.created_at 
                            FROM system_logs sl 
                            JOIN users u ON sl.user_id = u.id 
                            ORDER BY sl.created_at DESC 
                            LIMIT 5";
                    $activities = fetchAll($sql);
                    
                    if ($activities):
                        foreach ($activities as $activity):
                ?>
                <div class="d-flex justify-content-between border-bottom py-2">
                    <div>
                        <small><strong><?php echo htmlspecialchars($activity['full_name']); ?></strong></small><br>
                        <small class="text-muted"><?php echo htmlspecialchars($activity['action']); ?></small>
                    </div>
                    <small class="text-muted"><?php echo getRelativeTime($activity['created_at']); ?></small>
                </div>
                <?php 
                        endforeach;
                    else:
                ?>
                <small class="text-muted">No recent activity</small>
                <?php endif; ?>
                <?php } catch (Exception $e) { ?>
                <small class="text-muted">Unable to load activity</small>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- System Status -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">System Status</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <small><strong>Database:</strong> 
                        <?php echo testConnection() ? '<span class="text-success">Connected</span>' : '<span class="text-danger">Error</span>'; ?>
                        </small>
                    </div>
                    <div class="col-md-4">
                        <small><strong>Server:</strong> <span class="text-success">Running</span></small>
                    </div>
                    <div class="col-md-4">
                        <small><strong>Version:</strong> <?php echo APP_VERSION; ?></small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>