<?php
/**
 * Delete Document
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

// Define access constant
define('HRM_ACCESS', true);

// Start session
session_start();

// Include required files
require_once '../config/constants.php';
require_once '../config/database.php';
require_once '../includes/functions.php';

// Check authentication
if (!isLoggedIn()) {
    header('Location: ' . BASE_URL . 'auth/login.php');
    exit;
}

// Require site admin permission
requirePermission(ROLE_SITE_ADMIN);

$currentUser = getCurrentUser();

// Process deletion request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        setFlashMessage('Invalid security token.', 'danger');
    } else {
        $document_id = (int)($_POST['document_id'] ?? 0);
        $application_id = (int)($_POST['application_id'] ?? 0);
        
        if (!$document_id || !$application_id) {
            setFlashMessage('Invalid document or application ID.', 'danger');
        } else {
            try {
                // Get document details with access control
                $sql = "SELECT ed.*, ja.submitted_by 
                        FROM employee_documents ed
                        JOIN job_applications ja ON ed.application_id = ja.id
                        WHERE ed.id = ? AND ed.application_id = ? AND ja.submitted_by = ?";
                
                $document = fetchOne($sql, [$document_id, $application_id, $currentUser['id']]);
                
                if (!$document) {
                    setFlashMessage('Document not found or access denied.', 'danger');
                } else {
                    beginTransaction();
                    
                    // Delete physical file
                    if (file_exists($document['file_path'])) {
                        unlink($document['file_path']);
                    }
                    
                    // Delete database record
                    deleteRecord('employee_documents', 'id = ?', [$document_id]);
                    
                    // Log activity
                    logActivity($currentUser['id'], 'delete', 'employee_documents', $document_id);
                    
                    commit();
                    setFlashMessage('Document deleted successfully.', 'success');
                }
                
            } catch (Exception $e) {
                rollback();
                error_log("Error deleting document: " . $e->getMessage());
                setFlashMessage('Error deleting document. Please try again.', 'danger');
            }
        }
    }
} else {
    setFlashMessage('Invalid request method.', 'danger');
}

// Redirect back to upload page
$application_id = (int)($_POST['application_id'] ?? $_GET['app_id'] ?? 0);
if ($application_id) {
    header('Location: upload.php?app_id=' . $application_id);
} else {
    header('Location: ../employees/view_applications.php');
}
exit;
?>