</div>
    </main>

    <!-- Footer -->
    <footer class="bg-light border-top mt-5">
        <div class="container py-4">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <img src="<?php echo ASSETS_URL; ?>images/logo.png" alt="<?php echo COMPANY_NAME; ?>" 
                             style="height: 40px; margin-right: 15px;" onerror="this.style.display='none'">
                        <div>
                            <h6 class="mb-1 text-dark"><?php echo COMPANY_NAME; ?></h6>
                            <small class="text-muted"><?php echo COMPANY_ADDRESS; ?></small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 text-md-end">
                    <div class="mb-2">
                        <small class="text-muted">
                            <i class="fas fa-phone me-1"></i><?php echo COMPANY_PHONE; ?>
                            <span class="mx-2">|</span>
                            <i class="fas fa-envelope me-1"></i><?php echo COMPANY_EMAIL; ?>
                        </small>
                    </div>
                    <small class="text-muted">
                        © <?php echo date('Y'); ?> <?php echo COMPANY_NAME; ?>. All rights reserved.
                        <span class="mx-2">|</span>
                        Version <?php echo APP_VERSION; ?>
                    </small>
                </div>
            </div>
        </div>
    </footer>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmModalLabel">Confirm Action</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="confirmMessage">Are you sure you want to proceed?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="confirmButton">Confirm</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Modal -->
    <div class="modal fade" id="loadingModal" tabindex="-1" aria-labelledby="loadingModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center py-4">
                    <div class="spinner mb-3"></div>
                    <h6 id="loadingMessage">Processing...</h6>
                    <small class="text-muted">Please wait while we process your request.</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <!-- jQuery -->
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.0/dist/jquery.min.js"></script>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Font Awesome -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>

    <!-- Common JavaScript Functions -->
    <script>
        // Global Variables
        const BASE_URL = '<?php echo BASE_URL; ?>';
        const CSRF_TOKEN = '<?php echo generateCSRFToken(); ?>';
        
        // Loading Functions
        function showLoading(message = 'Processing...') {
            $('#loadingMessage').text(message);
            $('#loadingModal').modal('show');
        }
        
        function hideLoading() {
            $('#loadingModal').modal('hide');
        }
        
        function showLoadingOverlay() {
            $('#loadingOverlay').show();
        }
        
        function hideLoadingOverlay() {
            $('#loadingOverlay').hide();
        }
        
        // Confirmation Dialog
        function confirmAction(message, callback, title = 'Confirm Action') {
            $('#confirmModalLabel').text(title);
            $('#confirmMessage').text(message);
            $('#confirmButton').off('click').on('click', function() {
                $('#confirmModal').modal('hide');
                if (typeof callback === 'function') {
                    callback();
                }
            });
            $('#confirmModal').modal('show');
        }
        
        // Flash Messages
        function showAlert(message, type = 'info', duration = 5000) {
            const alertId = 'alert-' + Date.now();
            const alertHtml = `
                <div class="alert alert-${type} alert-dismissible fade show" id="${alertId}" role="alert">
                    <i class="fas fa-${getAlertIcon(type)} me-2"></i>
                    ${message}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            `;
            
            // Add to page
            if ($('.alert-container').length) {
                $('.alert-container').prepend(alertHtml);
            } else {
                $('.main-content .container-fluid').prepend('<div class="alert-container">' + alertHtml + '</div>');
            }
            
            // Auto-hide after duration
            if (duration > 0) {
                setTimeout(() => {
                    $('#' + alertId).alert('close');
                }, duration);
            }
        }
        
        function getAlertIcon(type) {
            const icons = {
                'success': 'check-circle',
                'info': 'info-circle',
                'warning': 'exclamation-triangle',
                'danger': 'exclamation-circle',
                'error': 'exclamation-circle'
            };
            return icons[type] || 'info-circle';
        }
        
        // Form Validation
        function validateForm(formId) {
            let isValid = true;
            const form = $('#' + formId);
            
            // Clear previous validation states
            form.find('.is-invalid').removeClass('is-invalid');
            form.find('.invalid-feedback').remove();
            
            // Required fields
            form.find('[required]').each(function() {
                const field = $(this);
                const value = field.val().trim();
                
                if (!value) {
                    markFieldInvalid(field, 'This field is required');
                    isValid = false;
                }
            });
            
            // Email validation
            form.find('input[type="email"]').each(function() {
                const field = $(this);
                const value = field.val().trim();
                
                if (value && !isValidEmail(value)) {
                    markFieldInvalid(field, 'Please enter a valid email address');
                    isValid = false;
                }
            });
            
            // Phone validation
            form.find('input[data-type="phone"]').each(function() {
                const field = $(this);
                const value = field.val().trim();
                
                if (value && !isValidPhone(value)) {
                    markFieldInvalid(field, 'Please enter a valid phone number');
                    isValid = false;
                }
            });
            
            // NIC validation
            form.find('input[data-type="nic"]').each(function() {
                const field = $(this);
                const value = field.val().trim();
                
                if (value && !isValidNIC(value)) {
                    markFieldInvalid(field, 'Please enter a valid NIC number');
                    isValid = false;
                }
            });
            
            return isValid;
        }
        
        function markFieldInvalid(field, message) {
            field.addClass('is-invalid');
            field.after('<div class="invalid-feedback">' + message + '</div>');
        }
        
        // Validation Functions
        function isValidEmail(email) {
            const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return regex.test(email);
        }
        
        function isValidPhone(phone) {
            const regex = /^[+]?[0-9\s\-\(\)]{7,15}$/;
            return regex.test(phone);
        }
        
        function isValidNIC(nic) {
            const regex = /^([0-9]{9}[xXvV]|[0-9]{12})$/;
            return regex.test(nic);
        }
        
        // AJAX Helper
        function makeAjaxRequest(url, data, method = 'POST') {
            return $.ajax({
                url: url,
                type: method,
                data: Object.assign({ csrf_token: CSRF_TOKEN }, data),
                dataType: 'json',
                beforeSend: function() {
                    showLoading();
                },
                complete: function() {
                    hideLoading();
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', error);
                    showAlert('An error occurred. Please try again.', 'danger');
                }
            });
        }
        
        // File Upload Helper
        function validateFileUpload(fileInput, maxSize = <?php echo MAX_FILE_SIZE; ?>, allowedTypes = []) {
            const file = fileInput.files[0];
            if (!file) return true;
            
            // Check file size
            if (file.size > maxSize) {
                showAlert('File size exceeds maximum limit of ' + formatFileSize(maxSize), 'warning');
                fileInput.value = '';
                return false;
            }
            
            // Check file type
            if (allowedTypes.length > 0) {
                const fileExtension = file.name.split('.').pop().toLowerCase();
                if (!allowedTypes.includes(fileExtension)) {
                    showAlert('File type not allowed. Allowed types: ' + allowedTypes.join(', '), 'warning');
                    fileInput.value = '';
                    return false;
                }
            }
            
            return true;
        }
        
        // Utility Functions
        function formatFileSize(bytes) {
            if (bytes === 0) return '0 Bytes';
            const k = 1024;
            const sizes = ['Bytes', 'KB', 'MB', 'GB'];
            const i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
        }
        
        function formatCurrency(amount) {
            return 'Rs. ' + parseFloat(amount).toLocaleString('en-US', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        }
        
        function formatDate(dateString, format = 'dd/mm/yyyy') {
            if (!dateString) return '-';
            const date = new Date(dateString);
            const day = date.getDate().toString().padStart(2, '0');
            const month = (date.getMonth() + 1).toString().padStart(2, '0');
            const year = date.getFullYear();
            
            if (format === 'dd/mm/yyyy') {
                return `${day}/${month}/${year}`;
            } else if (format === 'yyyy-mm-dd') {
                return `${year}-${month}-${day}`;
            }
            return dateString;
        }
        
        // Table Functions
        function initDataTable(tableId, options = {}) {
            const defaultOptions = {
                pageLength: <?php echo RECORDS_PER_PAGE; ?>,
                responsive: true,
                order: [[0, 'desc']],
                language: {
                    search: "Search:",
                    lengthMenu: "Show _MENU_ entries",
                    info: "Showing _START_ to _END_ of _TOTAL_ entries",
                    infoEmpty: "No entries found",
                    infoFiltered: "(filtered from _MAX_ total entries)",
                    paginate: {
                        first: "First",
                        last: "Last",
                        next: "Next",
                        previous: "Previous"
                    }
                },
                dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>' +
                     '<"row"<"col-sm-12"tr>>' +
                     '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
            };
            
            return $('#' + tableId).DataTable(Object.assign(defaultOptions, options));
        }
        
        function exportTableData(tableId, filename, format = 'excel') {
            const table = $('#' + tableId).DataTable();
            
            if (format === 'excel') {
                table.button('excel:name').trigger();
            } else if (format === 'pdf') {
                table.button('pdf:name').trigger();
            } else if (format === 'csv') {
                table.button('csv:name').trigger();
            }
        }
        
        // Print Functions
        function printPage() {
            window.print();
        }
        
        function printElement(elementId) {
            const element = document.getElementById(elementId);
            const printWindow = window.open('', '_blank');
            printWindow.document.write(`
                <html>
                    <head>
                        <title>Print</title>
                        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
                        <style>
                            body { font-size: 12px; }
                            .no-print { display: none !important; }
                        </style>
                    </head>
                    <body>
                        ${element.innerHTML}
                    </body>
                </html>
            `);
            printWindow.document.close();
            printWindow.print();
        }
        
        // Auto-save Functions
        let autoSaveTimer;
        function enableAutoSave(formId, saveUrl, interval = 30000) {
            clearInterval(autoSaveTimer);
            autoSaveTimer = setInterval(function() {
                const formData = $('#' + formId).serialize();
                $.ajax({
                    url: saveUrl,
                    type: 'POST',
                    data: formData + '&auto_save=1&csrf_token=' + CSRF_TOKEN,
                    success: function(response) {
                        if (response.success) {
                            showAlert('Draft saved automatically', 'info', 2000);
                        }
                    },
                    error: function() {
                        console.log('Auto-save failed');
                    }
                });
            }, interval);
        }
        
        function disableAutoSave() {
            clearInterval(autoSaveTimer);
        }
        
        // Document Ready Functions
        $(document).ready(function() {
            // Initialize tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();
            
            // Initialize popovers
            $('[data-bs-toggle="popover"]').popover();
            
            // Auto-hide alerts after 5 seconds
            setTimeout(function() {
                $('.alert:not(.alert-permanent)').fadeOut('slow');
            }, 5000);
            
            // Confirm before form submission for dangerous actions
            $('form[data-confirm]').on('submit', function(e) {
                e.preventDefault();
                const form = this;
                const message = $(form).data('confirm');
                confirmAction(message, function() {
                    form.submit();
                });
            });
            
            // Confirm before clicking dangerous links
            $('a[data-confirm]').on('click', function(e) {
                e.preventDefault();
                const link = this;
                const message = $(link).data('confirm');
                confirmAction(message, function() {
                    window.location.href = link.href;
                });
            });
            
            // File upload preview
            $('input[type="file"][data-preview]').on('change', function() {
                const file = this.files[0];
                const previewId = $(this).data('preview');
                
                if (file && file.type.startsWith('image/')) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        $('#' + previewId).attr('src', e.target.result).show();
                    };
                    reader.readAsDataURL(file);
                }
            });
            
            // Form field auto-formatting
            $('input[data-type="currency"]').on('input', function() {
                let value = $(this).val().replace(/[^\d.]/g, '');
                if (value) {
                    value = parseFloat(value).toFixed(2);
                    $(this).val(value);
                }
            });
            
            $('input[data-type="phone"]').on('input', function() {
                let value = $(this).val().replace(/[^\d+\-\s()]/g, '');
                $(this).val(value);
            });
            
            // Auto-resize textareas
            $('textarea[data-auto-resize]').on('input', function() {
                this.style.height = 'auto';
                this.style.height = (this.scrollHeight) + 'px';
            });
            
            // Character counter for text fields
            $('input[maxlength], textarea[maxlength]').each(function() {
                const maxLength = $(this).attr('maxlength');
                const counterId = $(this).attr('id') + '_counter';
                
                $(this).after(`<small class="text-muted" id="${counterId}">0/${maxLength} characters</small>`);
                
                $(this).on('input', function() {
                    const currentLength = $(this).val().length;
                    $(`#${counterId}`).text(`${currentLength}/${maxLength} characters`);
                    
                    if (currentLength > maxLength * 0.9) {
                        $(`#${counterId}`).removeClass('text-muted').addClass('text-warning');
                    } else {
                        $(`#${counterId}`).removeClass('text-warning').addClass('text-muted');
                    }
                });
            });
            
            // Session timeout warning
            <?php if (isLoggedIn()): ?>
            let sessionTimer;
            let warningShown = false;
            
            function resetSessionTimer() {
                clearTimeout(sessionTimer);
                warningShown = false;
                
                sessionTimer = setTimeout(function() {
                    if (!warningShown) {
                        warningShown = true;
                        showAlert('Your session will expire in 5 minutes. Please save your work.', 'warning', 0);
                        
                        setTimeout(function() {
                            window.location.href = BASE_URL + 'auth/logout.php?timeout=1';
                        }, 300000); // 5 minutes
                    }
                }, <?php echo (SESSION_TIMEOUT - 300) * 1000; ?>); // 5 minutes before timeout
            }
            
            // Reset timer on user activity
            $(document).on('click keypress mousemove', resetSessionTimer);
            resetSessionTimer();
            <?php endif; ?>
        });
        
        // Page-specific initialization
        if (typeof pageInit === 'function') {
            $(document).ready(pageInit);
        }
    </script>

    <!-- Page specific JavaScript -->
    <?php if (isset($additional_js)): ?>
        <?php echo $additional_js; ?>
    <?php endif; ?>

    <!-- DataTables (if needed) -->
    <?php if (isset($include_datatables) && $include_datatables): ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
    <?php endif; ?>

    <!-- Chart.js (if needed) -->
    <?php if (isset($include_charts) && $include_charts): ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <?php endif; ?>

    <!-- Date Picker (if needed) -->
    <?php if (isset($include_datepicker) && $include_datepicker): ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        $(document).ready(function() {
            $('input[type="date"]').flatpickr({
                dateFormat: "Y-m-d",
                allowInput: true
            });
        });
    </script>
    <?php endif; ?>

</body>
</html>