<?php
/**
 * Common Header Layout
 * Employee Recruitment Management System
 * RR Construction (Pvt) Ltd
 */

// Define access constant
define('HRM_ACCESS', true);

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include required files
require_once __DIR__ . '/../config/constants.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/functions.php';

// Check if user is logged in (except for login page)
$current_page = basename($_SERVER['PHP_SELF']);
$public_pages = ['login.php', 'index.php'];

if (!in_array($current_page, $public_pages) && !isLoggedIn()) {
    header('Location: ' . BASE_URL . 'auth/login.php');
    exit;
}

// Get current user info if logged in
$current_user = null;
if (isLoggedIn()) {
    $current_user = getCurrentUser();
}

// Set page title if not defined
if (!isset($page_title)) {
    $page_title = APP_NAME;
}

// Set active menu item if not defined
if (!isset($active_menu)) {
    $active_menu = '';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?> - <?php echo APP_NAME; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo ASSETS_URL; ?>images/favicon.ico">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: <?php echo PRIMARY_COLOR; ?>;
            --secondary-color: <?php echo SECONDARY_COLOR; ?>;
            --success-color: <?php echo SUCCESS_COLOR; ?>;
            --warning-color: <?php echo WARNING_COLOR; ?>;
            --danger-color: <?php echo DANGER_COLOR; ?>;
            --info-color: <?php echo INFO_COLOR; ?>;
        }
        
        body {
            font-family: 'Arial', sans-serif;
            font-size: 14px;
            background-color: #f8f9fa;
            color: var(--secondary-color);
        }
        
        /* Header Styles */
        .main-header {
            background: var(--primary-color);
            color: white;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .main-header .navbar-brand {
            font-weight: bold;
            font-size: 1.4rem;
        }
        
        .main-header .company-info {
            font-size: 0.9rem;
            opacity: 0.9;
        }
        
        /* Navigation Styles */
        .main-nav {
            background-color: white;
            border-bottom: 1px solid #e5e7eb;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .main-nav .nav-link {
            color: var(--secondary-color);
            font-weight: 500;
            padding: 12px 20px;
            border-radius: 0;
            transition: all 0.3s ease;
            position: relative;
        }
        
        .main-nav .nav-link:hover {
            color: var(--primary-color);
            background-color: #f9fafb;
        }
        
        .main-nav .nav-link.active {
            color: var(--primary-color);
            background-color: #fef2f2;
            border-bottom: 2px solid var(--primary-color);
        }
        
        .main-nav .nav-link i {
            margin-right: 8px;
            width: 16px;
            text-align: center;
        }
        
        /* User Menu */
        .user-menu .dropdown-toggle::after {
            display: none;
        }
        
        .user-menu .btn {
            border: none;
            background: none;
            color: white;
            padding: 8px 15px;
            border-radius: 20px;
            transition: background-color 0.3s ease;
        }
        
        .user-menu .btn:hover {
            background-color: rgba(255,255,255,0.1);
        }
        
        /* Breadcrumb */
        .breadcrumb-section {
            background-color: white;
            padding: 15px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .breadcrumb {
            background: none;
            padding: 0;
            margin: 0;
        }
        
        .breadcrumb-item a {
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .breadcrumb-item.active {
            color: var(--secondary-color);
        }
        
        /* Content Area */
        .main-content {
            padding: 20px 0;
            min-height: calc(100vh - 200px);
        }
        
        /* Cards */
        .card {
            border: none;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            border-radius: 8px;
        }
        
        .card-header {
            background-color: var(--primary-color);
            color: white;
            border-radius: 8px 8px 0 0 !important;
            font-weight: 600;
            padding: 15px 20px;
        }
        
        /* Buttons */
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-primary:hover {
            background-color: #b91c1c;
            border-color: #b91c1c;
        }
        
        /* Status Badges */
        .status-badge {
            font-size: 0.875rem;
            font-weight: 500;
            padding: 6px 12px;
            border-radius: 20px;
        }
        
        /* Tables */
        .table th {
            background-color: #f9fafb;
            border-bottom: 2px solid #e5e7eb;
            font-weight: 600;
            color: var(--secondary-color);
        }
        
        /* Forms */
        .form-label {
            font-weight: 600;
            color: var(--secondary-color);
            margin-bottom: 8px;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(220, 38, 38, 0.25);
        }
        
        /* Alerts */
        .alert {
            border: none;
            border-radius: 8px;
            font-weight: 500;
        }
        
        /* Loading Spinner */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }
        
        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .main-header .company-info {
                display: none;
            }
            
            .main-nav .nav-link {
                padding: 10px 15px;
                font-size: 0.9rem;
            }
            
            .main-content {
                padding: 15px 0;
            }
        }
        
        /* Print Styles */
        @media print {
            .main-header,
            .main-nav,
            .user-menu,
            .breadcrumb-section {
                display: none !important;
            }
            
            .main-content {
                padding: 0;
            }
        }
    </style>
    
    <!-- Page specific CSS -->
    <?php if (isset($additional_css)): ?>
        <?php echo $additional_css; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
    </div>

    <?php if (isLoggedIn()): ?>
    <!-- Main Header -->
    <header class="main-header">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center py-3">
                <div>
                    <h1 class="navbar-brand mb-0">
                        <i class="fas fa-building me-2"></i>
                        <?php echo COMPANY_NAME; ?>
                    </h1>
                    <div class="company-info">
                        <i class="fas fa-users me-1"></i>
                        <?php echo APP_NAME; ?>
                    </div>
                </div>
                
                <!-- User Menu -->
                <div class="user-menu dropdown">
                    <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user-circle me-2"></i>
                        <?php echo htmlspecialchars($current_user['full_name']); ?>
                        <small class="d-block text-start"><?php echo getRoleName($current_user['role']); ?></small>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><h6 class="dropdown-header">Account</h6></li>
                        <li>
                            <a class="dropdown-item" href="<?php echo BASE_URL; ?>profile.php">
                                <i class="fas fa-user me-2"></i>My Profile
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo BASE_URL; ?>change-password.php">
                                <i class="fas fa-key me-2"></i>Change Password
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="<?php echo BASE_URL; ?>auth/logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Navigation -->
    <nav class="main-nav">
        <div class="container">
            <ul class="nav nav-pills">
                <!-- Dashboard -->
                <li class="nav-item">
                    <a class="nav-link <?php echo ($active_menu === 'dashboard') ? 'active' : ''; ?>" 
                       href="<?php echo getDashboardUrl($current_user['role']); ?>">
                        <i class="fas fa-tachometer-alt"></i>Dashboard
                    </a>
                </li>
                
                <?php if (hasPermission($current_user['role'], ROLE_SITE_ADMIN)): ?>
                <!-- Employee Requests -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo (in_array($active_menu, ['requests', 'create_request'])) ? 'active' : ''; ?>" 
                       data-bs-toggle="dropdown" href="#" role="button">
                        <i class="fas fa-file-alt"></i>Employee Requests
                    </a>
                    <ul class="dropdown-menu">
                        <?php if (in_array($current_user['role'], [ROLE_SITE_ADMIN])): ?>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>requests/create_request.php">
                            <i class="fas fa-plus me-2"></i>New Request</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>requests/view_requests.php">
                            <i class="fas fa-list me-2"></i>View Requests</a></li>
                        <?php if (in_array($current_user['role'], [ROLE_PROJECT_MANAGER, ROLE_GENERAL_MANAGER, ROLE_HR_MANAGER])): ?>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>requests/approve_request.php">
                            <i class="fas fa-check me-2"></i>Pending Approvals</a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                
                <?php if (hasPermission($current_user['role'], ROLE_SITE_ADMIN)): ?>
                <!-- Job Applications -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo (in_array($active_menu, ['applications', 'create_application'])) ? 'active' : ''; ?>" 
                       data-bs-toggle="dropdown" href="#" role="button">
                        <i class="fas fa-users"></i>Applications
                    </a>
                    <ul class="dropdown-menu">
                        <?php if (in_array($current_user['role'], [ROLE_SITE_ADMIN])): ?>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>employees/application_form.php">
                            <i class="fas fa-user-plus me-2"></i>New Application</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>employees/view_applications.php">
                            <i class="fas fa-list me-2"></i>View Applications</a></li>
                        <?php if (in_array($current_user['role'], [ROLE_PROJECT_MANAGER, ROLE_HR_MANAGER, ROLE_ACCOUNTANT])): ?>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>employees/approve_application.php">
                            <i class="fas fa-check-circle me-2"></i>Pending Approvals</a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                
                <?php if (in_array($current_user['role'], [ROLE_HR_MANAGER, ROLE_GENERAL_MANAGER, ROLE_SUPER_ADMIN])): ?>
                <!-- Reports -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($active_menu === 'reports') ? 'active' : ''; ?>" 
                       data-bs-toggle="dropdown" href="#" role="button">
                        <i class="fas fa-chart-bar"></i>Reports
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>reports/request_summary.php">
                            <i class="fas fa-file-alt me-2"></i>Request Summary</a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>reports/application_summary.php">
                            <i class="fas fa-users me-2"></i>Application Summary</a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>reports/hiring_report.php">
                            <i class="fas fa-user-check me-2"></i>Hiring Report</a></li>
                    </ul>
                </li>
                <?php endif; ?>
                
                <?php if ($current_user['role'] === ROLE_SUPER_ADMIN): ?>
                <!-- Administration -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($active_menu === 'admin') ? 'active' : ''; ?>" 
                       data-bs-toggle="dropdown" href="#" role="button">
                        <i class="fas fa-cog"></i>Administration
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>admin/users.php">
                            <i class="fas fa-users-cog me-2"></i>User Management</a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>admin/projects.php">
                            <i class="fas fa-project-diagram me-2"></i>Project Management</a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>admin/system_logs.php">
                            <i class="fas fa-history me-2"></i>System Logs</a></li>
                        <li><a class="dropdown-item" href="<?php echo BASE_URL; ?>admin/settings.php">
                            <i class="fas fa-sliders-h me-2"></i>System Settings</a></li>
                    </ul>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </nav>

    <!-- Breadcrumb -->
    <?php if (isset($breadcrumbs) && !empty($breadcrumbs)): ?>
    <div class="breadcrumb-section">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo getDashboardUrl($current_user['role']); ?>">
                            <i class="fas fa-home"></i> Dashboard
                        </a>
                    </li>
                    <?php foreach ($breadcrumbs as $index => $crumb): ?>
                        <?php if ($index === count($breadcrumbs) - 1): ?>
                            <li class="breadcrumb-item active" aria-current="page">
                                <?php echo htmlspecialchars($crumb['title']); ?>
                            </li>
                        <?php else: ?>
                            <li class="breadcrumb-item">
                                <a href="<?php echo htmlspecialchars($crumb['url']); ?>">
                                    <?php echo htmlspecialchars($crumb['title']); ?>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ol>
            </nav>
        </div>
    </div>
    <?php endif; ?>
    <?php endif; ?>

    <!-- Main Content -->
    <main class="main-content">
        <div class="container">
            <!-- Flash Messages -->
            <?php displayFlashMessages(); ?>
            
            <!-- Page Content -->